/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.core.definitions.AEItems;
import appeng.facade.IFacadeItem;
import appeng.items.parts.FacadeItem;
import appeng.parts.CableBusStorage;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FacadeContainer
implements IFacadeContainer {
    private final CableBusStorage storage;
    private final Consumer<Direction> changeCallback;

    public FacadeContainer(CableBusStorage cbs, Consumer<Direction> changeCallback) {
        this.storage = cbs;
        this.changeCallback = changeCallback;
    }

    @Override
    public boolean canAddFacade(IFacadePart a) {
        return this.getFacade(a.getSide()) == null;
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.canAddFacade(a)) {
            this.storage.setFacade(a.getSide(), a);
            this.notifyChange(a.getSide());
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, Direction side) {
        if (side != null && this.storage.getFacade(side) != null) {
            this.storage.removeFacade(side);
            this.notifyChange(side);
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(Direction side) {
        return this.storage.getFacade(side);
    }

    private String getNbtKey(Direction side) {
        return "facade:" + side.ordinal();
    }

    @Override
    public void readFromNBT(CompoundTag c) {
        for (Direction side : Direction.values()) {
            Item item;
            ItemStack is;
            this.storage.removeFacade(side);
            String key = this.getNbtKey(side);
            if (!c.m_128425_(key, 10) || (is = ItemStack.m_41712_((CompoundTag)c.m_128469_(key))).m_41619_() || !((item = is.m_41720_()) instanceof IFacadeItem)) continue;
            IFacadeItem facadeItem = (IFacadeItem)item;
            this.storage.setFacade(side, facadeItem.createPartFromItemStack(is, side));
        }
    }

    @Override
    public void writeToNBT(CompoundTag c) {
        for (Direction side : Direction.values()) {
            if (this.storage.getFacade(side) == null) continue;
            CompoundTag data = new CompoundTag();
            this.storage.getFacade(side).getItemStack().m_41739_(data);
            c.m_128365_(this.getNbtKey(side), (Tag)data);
        }
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf out) {
        byte facadeSides = out.readByte();
        boolean changed = false;
        for (Direction side : Direction.values()) {
            int ix = 1 << side.ordinal();
            if ((facadeSides & ix) == ix) {
                int id = out.m_130242_();
                FacadeItem ifa = AEItems.FACADE.m_5456_();
                ItemStack facade = ifa.createFromID(id);
                if (facade == null) continue;
                changed = changed || this.storage.getFacade(side) == null;
                this.storage.setFacade(side, ifa.createPartFromItemStack(facade, side));
                continue;
            }
            changed = changed || this.storage.getFacade(side) != null;
            this.storage.removeFacade(side);
        }
        return changed;
    }

    @Override
    public void writeToStream(FriendlyByteBuf out) {
        int facadeSides = 0;
        for (Direction side : Direction.values()) {
            if (this.getFacade(side) == null) continue;
            facadeSides |= 1 << side.ordinal();
        }
        out.writeByte((int)((byte)facadeSides));
        for (Direction side : Direction.values()) {
            IFacadePart part = this.getFacade(side);
            if (part == null) continue;
            int itemID = Item.m_41393_((Item)part.getItem());
            out.m_130130_(itemID);
        }
    }

    @Override
    public boolean isEmpty() {
        for (Direction side : Direction.values()) {
            if (this.storage.getFacade(side) == null) continue;
            return false;
        }
        return true;
    }

    private void notifyChange(Direction side) {
        this.changeCallback.accept(side);
    }
}

